# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys, os
try:
     import pygtk
     pygtk.require("2.0")
except:
      pass
try:
    import gtk
    import gtk.glade
except:
    sys.exit(1)

import re
import copy

from glade_window import GladeWindow
from window.WindowWatcher import WindowWatcher
from Client import Client

class EarCandyVolumeSlider(GladeWindow):
    def __init__(self, core):
        self.core = core
            
        GladeWindow.__init__(self, "pulseoptions.glade", "popup_volume_control")
        
        self.vscale_volume = self.wtree.get_widget("vscale_volume")
        self.image_status = self.wtree.get_widget("image_status")

        signals = {
          "on_popup_volume_control_focus_out_event" : self.on_popup_volume_control_focus_out_event,
          "on_vscale_volume_change_value" : self.on_vscale_volume_change_value,
          "on_button_suspend_clicked" : self.on_button_suspend_clicked

        }

        self.wtree.signal_autoconnect(signals)

        self.window.connect("button-press-event", self.on_popup_volume_control_button_press_event)
        self.window.connect("key-press-event", self.on_popup_volume_control_key_press_event)

        #for val in self.core.display.values():
        #    self.combobox_client_category.append_text( val )
        self.active = False

    def on_button_suspend_clicked(self, widget):

        self.core.set_active( not self.core.active )
        self.stop()

    def update_active_status(self):
        if self.core.active:
            self.image_status.set_from_stock("gtk-media-pause", 4)
        else:
            self.image_status.set_from_stock("gtk-media-play", 4) 

    def on_popup_volume_control_button_press_event(self, widget, event):
        self.stop()
        return False

    def on_popup_volume_control_key_press_event(self, widget, event):
        self.stop()
        return True

    def on_vscale_volume_change_value(self, widget, a, b):
        self.core.pa.set_sink_volume_by_name(self.core.managed_output_name, b  )

    def on_popup_volume_control_focus_out_event(self, widget, b):
        self.stop()

    def run(self):
        self.active = True
        self.core.get_current_sink_volume()
        self.window.present()
        gtk.gdk.keyboard_grab(self.window.window, True)
        gtk.gdk.pointer_grab(self.window.window, True,
            gtk.gdk.BUTTON_PRESS_MASK |
            gtk.gdk.BUTTON_RELEASE_MASK |
            gtk.gdk.POINTER_MOTION_MASK
        )

    def set_volume(self, value):
        #if not self.window.is_active():
            self.vscale_volume.set_value( value )

    def stop(self):
        gtk.gdk.keyboard_ungrab()
        gtk.gdk.pointer_ungrab()
        self.window.hide()
        self.active = False
